load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

;************************************************
; add error bars
;************************************************  
undef("add_y_errorbar")
procedure add_y_errorbar(wksy, plot, x[*]:numeric,y[*]:numeric, ymin[*]:numeric, ymax[*]:numeric, res)
local dimz, xpoints, ypoints, gsres, i
begin
  gsres = res
  dimz  = dimsizes(y)

  xpoints = (/x, x/)
  ypoints = (/ y-(y-ymin), y+(ymax-y)/)
  do i=0, dimz(0)-1
     plot@$tostring("y_errorbar"+i)$ = gsn_add_polyline(wksy, plot, xpoints(:,i), ypoints(:,i), gsres )
  end do
end

begin
;####################################################################################################################
;####################################################################################################################
;####################################################################################################################
;SCRIPT N. 1
;####################################################################################################################
;####################################################################################################################
;####################################################################################################################
;####################################################################################################################

; Script Time
begTime = get_cpu_time()

;--------------------------------------------------------
; SET MAIN INPUT and OUTPUT FOLDER 

;case_studies = (/"Bily_Kriz", "Collelongo", "LeBray", "Soroe", "Hyytiala"/)
;codes        = (/"CZ-BK1", "IT-Col", "FR-LBr", "DK-Sor", "FI-Hyy"/)
labels       = (/"2009-2019","2019-2029","2029-2039","2039-2049",\
                 "2049-2059","2059-2069","2069-2079","2079-2089","2089-2099"/)                         ; don't want labels

vartoplot   = (/"ESM2","gpp","reco","nee", "ESM4","gpp","reco","nee", "ESM6","gpp","reco","nee"/)
vartoplotM  = (/"GPP","NEE","RECO","GPP","NEE","RECO","GPP","NEE","RECO"/)
nvartoplot  = dimsizes(vartoplot)

rcps         = (/"rcp2p6", "rcp6p0"/)

ESM_box_plot  = asciiread("./var_perc.csv",-1,"string")
str           = str_split_csv (ESM_box_plot, ",",-1)

case_studies  = tostring(str(0,1:))
ncstudies     = dimsizes(case_studies)

year          = tofloat (str(2::,0)) ; x
variable      = tostring(str(1,:))

;DEBUG
;print("---------------")
;print(" CASE STUDIES  ")
;print("---------------")
;print(ESM_box_plot)
;print(str1)
;print(year)
;print(variable)
;print(case_studies)
;print(ncstudies)
;exit

plot_2p6 = new((/15/),graphic)
plot_6p0 = new((/15/),graphic)

;type                    = "png" 
type                    = "x11" 
wksb                     = gsn_open_wks (type,"box")
wksb@wkOrientation       = "landscape"

;--------------------------------------------------------
;A) LOOP over CASE SSTUDIES 
        do vt=0,ncstudies-1,6

;print(day_scenario(vt))
print("-------------------------------------------------------------------------------")   
print("-------------------------------------------------------------------------------")   
print("    Working on case studies "+case_studies(vt)+ "------------------------------")     
print("-------------------------------------------------------------------------------")   
print("-------------------------------------------------------------------------------")   
;exit

;-------> Box plot               

;---------> rcp2.6rcps
               gpp           = tofloat(str(2::,vt+1))*100  
               gpp@units     = "(%)" 
               gpp@names     = variable(vt+1) 

               nee           = tofloat(str(2::,vt+2))*100  
               nee@units     = "(%)" 
               nee@names     = variable(vt+2) 

               reco           = tofloat(str(2::,vt+3))*100 
               reco@units     = "(%)" 
               reco@names     = variable(vt+3) 

;DEBUG
;print(gpp)
;printVarSummary(gpp)
;print(nee)
;printVarSummary(nee)
;print(reco)
;printVarSummary(reco)
;exit

;---------> rcp6.0
               gpp6           = tofloat(str(2::,vt+4))*100  
               gpp6@units     = "(%)" 
               gpp6@names     = variable(vt+4) 

               nee6           = tofloat(str(2::,vt+5))*100  
               nee6@units     = "(%)" 
               nee6@names     = variable(vt+5) 

               reco6           = tofloat(str(2::,vt+6))*100 
               reco6@units     = "(%)" 
               reco6@names     = variable(vt+6) 

;DEBUG
;print(gpp6)
;printVarSummary(gpp6)
;print(nee6)
;printVarSummary(nee6)
;print(reco6)
;printVarSummary(reco6)
;exit

                var      = (/"GPP","NEE", "RECO"/)
                colors = read_colormap_file("perc2_9lev")
;--------------------------------------------------------
;B) LOOP over GRAPHIC 
         do gt=0,2,1


            resb             = True                        ; plot mods desired
            resb@gsnDraw     = False      ; Will draw later, after overlaying
            resb@gsnFrame    = False      ; all plots

           if     ( gt .eq. 0) then
               resb@trYMinF              = -10          ; min value on y-axis
               resb@trYMaxF              = 60            ; max value on y-axis
               x1 = gpp
               x2 = gpp6
           else if ( gt .eq. 1) then
               resb@trYMinF              = -120            ; min value on y-axis
               resb@trYMaxF              = 10           ; max value on y-axis
               x1 =nee 
               x2 =nee6
           else if  ( gt .eq. 2) then
               resb@trYMinF               =   0            ; min value on y-axis
               resb@trYMaxF               = 160            ; max value on y-axis
               x1 =reco 
               x2 =reco6
           end if 
           end if 
           end if 

            resb@gsnMaximize         = True
            ;resb@tiMainString        = case_studies(vt) 

            resb@tiXAxisString        = "years" ; y-axis label      
            resb@tiXAxisFontHeightF   = 0.015
            resb@tmXBLabelFontHeightF = 0.015
            resb@tmYLLabelFontHeightF = 0.02
            resb@tmXBMode             = "Manual"
            resb@tmXBTickSpacingF     = 10
            resb@trXMinF              = min(year)            ; min value on y-axis
            resb@trXMaxF              = max(year)+10            ; max value on y-axis
            resb@tmXBMinorOn          = "False"
            resb@tmYROn               = "False"
            
            resb@tiYAxisString =  var(gt)+" ~F33~D~F~%~F34~"
            resb@tiYAxisFontHeightF        = 0.02
            resb@tmYLLabelFontHeightF      = 0.015
            resb@gsnXYBarChartBarWidth     = 10;0.99  
            resb@gsnXYBarChart             = True ; create bar chart 
            resb@gsnYRefLine               = 0. ; reference line  
            ;resb@gsnXYBarChartFillOpacityF = 0.3 

            resb@gsnXYBarChartColors = colors(1:,:);/"orange","red","black","blue","green"/)
            plot1 = gsn_csm_xy (wksb,year+5,x1,resb)
            delete(resb@gsnXYBarChartColors)
            resb@gsnXYBarChartColors = colors(1:,:);/"orange","red","black","blue","green"/)
            plot2 = gsn_csm_xy (wksb,year+5,x2,resb)
            delete(resb@gsnXYBarChartColors)

            resy = resb  
            resy@gsnXYBarChart            = False ; create bar chart 
            resy@xyLineThicknessF         = 5
            resy@xyLineColor          = "navyblue"; create bar chart 
            plot3 = gsn_csm_xy (wksb,year+5,x1,resb)
            plot4 = gsn_csm_xy (wksb,year+5,x2,resb)
            
            overlay(plot1,plot3)
            overlay(plot2,plot4)

;draw(plot1)
;frame(wksb)
;draw(plot2)
;frame(wksb)

            if (vt .eq. 0) then
            print(vt+gt)
            plot_2p6(vt+gt) = plot1           
            plot_6p0(vt+gt) = plot2          
            elseif (vt .eq. 6) then 
            print (vt+gt-3) 
            plot_2p6(vt+gt-3) = plot1           
            plot_6p0(vt+gt-3) = plot2           
            elseif (vt .eq. 12) then
            print (vt+gt-6) 
            plot_2p6(vt+gt-6) = plot1          
            plot_6p0(vt+gt-6) = plot2           
            elseif (vt .eq. 18) then
            print (vt+gt-9) 
            plot_2p6(vt+gt-9) = plot1          
            plot_6p0(vt+gt-9) = plot2           
            elseif (vt .eq. 24) then
            print (vt+gt-12) 
            plot_2p6(vt+gt-12) = plot1          
            plot_6p0(vt+gt-12) = plot2           
            end if
delete(plot1)
delete(plot2)
delete(plot3)
delete(plot4)
;
         end do

;B)START --------- LOOP OVER GRAPHICS ----------------------

    end do
;--------------------------------------------------------
;A) LOOP over CASE STUDIES

delete(case_studies)
delete(labels)
delete(vartoplotM)
delete(gpp)
delete(reco)
delete(nee)
delete(resy)
delete(resb)

;###################################################################################################################
;####################################################################################################################
;####################################################################################################################
;SCRIPT N. 2
;####################################################################################################################
;####################################################################################################################
;####################################################################################################################
;####################################################################################################################


;--------------------------------------------------------
; SET MAIN INPUT and OUTPUT FOLDER 

case_studies = (/"Bily_Kriz", "Collelongo", "Hyytiala" ,"LeBray", "Soroe"/)
codes        = (/"CZ-BK1", "IT-Col", "FI-Hyy", "FR-LBr", "DK-Sor"/)
rcps         = (/"rcp2p6", "rcp6p0"/)
labels       = (/"1999-2009","2009-2019","2019-2029","2029-2039","2039-2049",\
                 "2049-2059","2059-2069","2069-2079","2079-2089","2089-2099"/)                         ; don't want labels
ncstudies    = dimsizes(case_studies)

scenario     = systemfunc("ls ./SCENARIO2/")
nscenario    = dimsizes(scenario)

;DEBUG
;print("---------------")
;print(" CASE STUDIES  ")
;print("---------------")
;print(nscenario)
;exit

     x_plot_avg_2p6 = new(15, graphic)
     x_plot_avg_6p0 = new(15, graphic)
     xt1 = 0
     xt2 = 0

     wksy                     = gsn_open_wks (type,"xy")
     wksy@wkOrientation       = "landscape"
;--------------------------------------------------------
;A) LOOP over SCENARIO 
    do ft=0,ncstudies-1

       dir_output = "./SCENARIO2/"+case_studies(ft)+"/"                                         ; path to save output data 
       files      = systemfunc("ls "+dir_output)
       nfiles     = dimsizes(files)

;DEBUG
;print("---------------")
;print("----FILES----")
;("---------------")
;print(scenario(ft))
;print(case_studies(ft))
;print(dir_output)
;print(files)
;exit
       
;;--------------------------------------------------------
;;B) LOOP over CASE STUDIES 
;      do st=0,ncstudies-1

;--------------------------------------------------------
;C) LOOP over RCPS 
         do rt=0,1

            day_scenario       = systemfunc("ls "+dir_output+"*"+rcps(rt)+"*")
            nday_scenario      = dimsizes(day_scenario)
;DEBUG
;print("---------------")
;print("----F= plot1ILES----")
;print("---------------")
;print(nday_scenario)
;print(nvartoplot)
;exit


;-------> Box p2yylot               
            box_plot    = new((/10,10/),float)   ; store the data realtive to a RCP 
            vartoplot   = (/"ESM2","gpp","reco","nee", "ESM4","gpp","reco","nee", "ESM6","gpp","reco","nee"/)
            vartoplotM  = (/" ","GPP","RECO","NEE", " ","GPP","RECO","NEE", " ","GPP","RECO","NEE"/)
            nvartoplot  = dimsizes(vartoplot)

;-------> Box p2yylot               
            xy_plot  = new((/11,109/),float)   ; store the data realtive to a RCP 
            x        = ispan (0,108,1)  
           

        if(case_studies(ft) .eq. "Hyytiala") then
           nday_scenario = 8
        end if 

;--------------------------------------------------------
;D) LOOP over BOXPLOT 
        do vt=0,nday_scenario-1,4


;print(day_scenario(vt))
print("-------------------------------------------------------------------------------")   
print("-------------------------------------------------------------------------------")   
print("    Working on case studies "+case_studies(ft)+" for scenario "+rcps(rt)+" and "+vartoplot(vt))     
print("-------------------------------------------------------------------------------")   
print("-------------------------------------------------------------------------------")   

;-------> xy plot
               ESM_box_plot  = asciiread(day_scenario(vt),-1,"string")
               str1          = str_split_csv (ESM_box_plot, ",",-1)
               variable1     = tostring(str1(0,:))
               year1         = tofloat(str1(1::,0)) ; x
              
               plot_gpp     = asciiread(day_scenario(vt+1),-1,"string")
               str_gpp      = str_split_csv (plot_gpp, ",",-1)

               plot_nee     = asciiread(day_scenario(vt+2),-1,"string")
               str_nee      = str_split_csv (plot_nee, ",",-1)
               
               plot_reco    = asciiread(day_scenario(vt+3),-1,"string")
               str_reco     = str_split_csv (plot_reco, ",",-1)
           
               gpp        = tofloat(str_gpp (1:,1:))
               nee        = tofloat(str_nee (1:,1:))
               reco       = tofloat(str_reco(1:,1:))


               if ( vt .eq. 0) then
                 xy_plot   (1:,0)   = year1    
                 xy_plot   (0,:)    = x    
                 xy_plot   (1:,1:12)    = gpp
                 xy_plot   (1:,13:24)   = reco
                 xy_plot   (1:,25:36)   = nee
               else if ( vt .eq. 4) then
                 xy_plot   (1:,37:48)   = gpp
                 xy_plot   (1:,49:60)   = reco
                 xy_plot   (1:,61:72)   = nee
               else if ( vt .eq.  8) then
                 xy_plot   (1:,73:84)   = gpp
                 xy_plot   (1:,85:96)   = reco
                 xy_plot   (1:,97:108)   = nee
               end if
               end if
               end if

;DEBUG
;print(day_scenario(vt))
;print(day_scenario(vt+1))
;print(str_gpp)
;print(plot_gpp)
;print(nee)
;print(reco)
;print(day_scenario(vt+2))
;print(plot_nee)
;print(day_scenario(vt+3))
;print(plot_reco)
;print(xy_plot)
;exit

delete(gpp)
delete(reco)
delete(nee)

          end do
;--------------------------------------------------------
;D) LOOP over BOXPLOT 

;DEBUG
;print(box_plot)
;exit

;-------> xy plot
         
          xy_gpp_amm  = new((/10,37/), float)
          xy_nee_amm  = new((/10,37/), float)
          xy_reco_amm = new((/10,37/), float)
         
          xy_gpp_amm   (:,0)  = year1 
          xy_nee_amm   (:,0)  = year1 
          xy_reco_amm  (:,0)  = year1 

;--------------------------------------------------------
;E) LOOP over BOXPLOT to AVG and MIN/MAX
          do mt=0,9

;--------------------------------------------------------
;F) LOOP over BOXPLOT to AVG and MIN/MAX
             do yt=0,11,1

             gpp_avg = dim_avg(xy_plot(mt+1,(/1+yt,37+yt,73+yt/)))
             gpp_min = dim_min(xy_plot(mt+1,(/1+yt,37+yt,73+yt/)))
             gpp_max = dim_max(xy_plot(mt+1,(/1+yt,37+yt,73+yt/)))
             xy_gpp_amm (mt,yt+1)  = gpp_avg
             xy_gpp_amm (mt,yt+13) = gpp_min
             xy_gpp_amm (mt,yt+25) = gpp_max

             reco_avg = dim_avg(xy_plot(mt+1,(/13+yt,49+yt,85+yt/)))
             reco_min = dim_min(xy_plot(mt+1,(/13+yt,49+yt,85+yt/)))
             reco_max = dim_max(xy_plot(mt+1,(/13+yt,49+yt,85+yt/)))
             xy_reco_amm (mt,yt+1)   = reco_avg
             xy_reco_amm (mt,yt+13)  = reco_min
             xy_reco_amm (mt,yt+25)  = reco_max

             nee_avg = dim_avg(xy_plot(mt+1,(/25+yt,61+yt,97+yt/)))
             nee_min = dim_min(xy_plot(mt+1,(/25+yt,61+yt,97+yt/)))
             nee_max = dim_max(xy_plot(mt+1,(/25+yt,61+yt,97+yt/)))
             xy_nee_amm (mt,yt+1)   = nee_avg
             xy_nee_amm (mt,yt+13)  = nee_min
             xy_nee_amm (mt,yt+25)  = nee_max

;DEBUG
;print(gpp_avg)
;print(gpp_min)
;print(gpp_max)
;exit

             end do
;F) LOOP over BOXPLOT to AVG and MIN/MAX
;--------------------------------------------------------

          end do
;E) LOOP over BOXPLOT to AVG and MIN/MAX
;--------------------------------------------------------

;DEBUG
;print(xy_gpp_amm)
;print(xy_nee_amm)
;print(xy_reco_amm)
;print(box_gpp_amm)
;print(box_nee_amm)
;print(box_reco_amm)
;exit

;-------> xy plot               
;AVG
xy_gpp_a   = tofloat(xy_gpp_amm  (:,1:12))
xy_reco_a  = tofloat(xy_reco_amm (:,1:12))
xy_nee_a   = tofloat(xy_nee_amm  (:,1:12))
;MIN
xy_gpp_mi   = tofloat(xy_gpp_amm  (:,13:24))
xy_reco_mi  = tofloat(xy_reco_amm (:,13:24))
xy_nee_mi   = tofloat(xy_nee_amm  (:,13:24))
;MIN
xy_gpp_ma   = tofloat(xy_gpp_amm  (:,25:36))
xy_reco_ma  = tofloat(xy_reco_amm (:,25:36))
xy_nee_ma   = tofloat(xy_nee_amm  (:,25:36))

xy_avg   = (/xy_gpp_a ,  xy_nee_a ,  xy_reco_a/)
xy_min   = (/xy_gpp_mi,  xy_nee_mi,  xy_reco_mi/)
xy_max   = (/xy_gpp_ma,  xy_nee_ma,  xy_reco_ma/)

var      = (/"GPP","NEE", "RECO"/)

;DEBUG             
;print("AVG")
;print(xy_gpp_a) 
;print(xy_nee_a) 
;print(xy_reco_a) 
;print("MIN")
;print(xy_gpp_mi ) 
;print(xy_nee_mi ) 
;print(xy_reco_mi) 
;print("MAX")
;print(xy_gpp_ma ) 
;print(xy_nee_ma ) 
;print(xy_reco_ma) 
;exit

;--------------------------------------------------------
;G) LOOP over GRAPHIC 
           do gt=0,2,1


;--------------------------------------------------------
; xyPLOT GRAPHIC

            resy                     = True             ; plot mods desired
           
           if  ( gt .eq. 0)  then    
               resy@trYMinF              = 0            ; min value on y-axis
               resy@trYMaxF              = 600            ; max value on y-axis
           else if  ( gt .eq. 1) then
               resy@trYMinF              = -300            ; min value on y-axis
               resy@trYMaxF              = 300           ; max value on y-axis
           else if ( gt .eq. 2) then
               resy@trYMinF              = 0            ; min value on y-axis
               resy@trYMaxF              = 600            ; max value on y-axis
           end if 
           end if 
           end if 
            
            ;resy@tiMainString        = rcps(rt)


            resy@gsnMaximize = True
            resy@gsnDraw     = False      ; Will draw later, after overlaying
            resy@gsnFrame    = False      ; all plots

            resy@tiYAxisString          = var(gt)+" "+"(gC m~S~-2~N~ m~S~-1~N~)"

;-          --Tyurn off some tickmarks
            resy@tmXTOn                 = False    ; bottom off
            resy@tmYROn                 = False    ; right off

            resy@xyLineThicknessF       = 5.0      ; default is 1
            resy@xyMonoDashPattern      = True     ; force all solid lines

            resy@tmXBMode          = "Explicit"         ; explicit labels
            resy@tmXBValues        = (/0,1,2,3,4,5,6,7,8,9,10,11,12,13/)
            resy@tmXBLabels = (/" ","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"," "/)

            resy@tiXAxisString        = "months" ; y-axis label      
            resy@tiXAxisFontHeightF   = 0.02
            resy@tmXBLabelFontHeightF = 0.015
            resy@tmYLLabelFontHeightF = 0.02
            resy@tmXBTickSpacingF     = 1
            resy@tmXBMinorOn          = "False"
            resy@tmYRBorderOn         = "False"
            resy@tmXTBorderOn         = "False"
            resy@gsnYRefLine          = 0

        
            xy_plot_avg    = new(10, graphic)
            xy_plot_minmax = new(10, graphic)

;D)START --------- LOOP OVER THE WV ----------------------
           do yt=0,9

              resy@xyLineColors = colors(yt:,:)
              xy_plot_avg(yt) = gsn_csm_xy(wksy,tofloat(ispan(1,12,1)),xy_avg(gt,yt,:),resy)

              ;Create a plot with the area between both curves filled in blue.
              resy@gsnXYFillColors = resy@xyLineColors
              resy@gsnXYFillOpacities = 0.3 
              resy@tfPolyDrawOrder   = "PreDraw"                   ; draw this first
              delete(resy@xyLineColors)
              resy@xyLineColor     = -1                           ; We don't want the line, so make it transparent.
              xy_plot_minmax(yt)  = gsn_csm_xy (wksy,ispan(1,12,1),(/xy_min(gt,yt,:),xy_max(gt,yt,:)/),resy)  ; Create filled XY plot.
              delete(resy@gsnXYFillColors)
              overlay(xy_plot_avg(yt),xy_plot_minmax(yt))

           end do
;D)START --------- LOOP OVER THE WV ----------------------

;DEBUG
;draw(xy_plot_avg)            ; This will draw all four plots
;frame(wksy)
;exit
    
;-----Overlay one plot on the other, so they become one plot.
            overlay(xy_plot_avg(0),xy_plot_avg(1))
            overlay(xy_plot_avg(0),xy_plot_avg(2))
            overlay(xy_plot_avg(0),xy_plot_avg(3))
            overlay(xy_plot_avg(0),xy_plot_avg(4))
            overlay(xy_plot_avg(0),xy_plot_avg(5))
            overlay(xy_plot_avg(0),xy_plot_avg(6))
            overlay(xy_plot_avg(0),xy_plot_avg(7))
            overlay(xy_plot_avg(0),xy_plot_avg(8))
            overlay(xy_plot_avg(0),xy_plot_avg(9))
;DEBUG
;draw(xy_plot_avg(0))            ; This will draw all four plots
;frame(wksy)
;exit

            if (rt .eq. 0) .and. (gt .eq. 2) then 
               xt1 = xt1+gt-1
print(xt1)
               x_plot_avg_2p6 (xt1) = xy_plot_avg(0)
               xt1 = xt1+1

            elseif (rt .eq. 0) then
               xt1 = xt1+gt
print(xt1)
               x_plot_avg_2p6 (xt1) = xy_plot_avg(0)

            elseif (rt .eq. 1) .and. (gt .eq. 2) then
               xt2 = xt2+gt-1
print(xt2)
               x_plot_avg_6p0 (xt2) = xy_plot_avg(0)
               xt2 = xt2+1

            elseif (rt .eq. 1) then
               xt2 = xt2+gt
print(xt2)
               x_plot_avg_6p0 (xt2) = xy_plot_avg(0)
            end if
            
             end do
;G) LOOP over GRAPHIC 
;--------------------------------------------------------

delete(day_scenario)
       end do
;--------------------------------------------------------
;C) LOOP over RCPS 

delete(files)

    end do
;A) LOOP over SCENARIO 

;print(plot_2p6)
;print(plot_6p0)
;print(x_plot_avg_2p6)
;print(x_plot_avg_6p0)
;exit

;************************************************
; create panel
;************************************************
codes1       = (/"CZ-BK1", "IT-Col", "FI-Hyy", "FR-LBr", "DK-Sor",\
                 "CZ-BK1", "IT-Col", "FI-Hyy", "FR-LBr", "DK-Sor",\
                 "CZ-BK1", "IT-Col", "FI-Hyy", "FR-LBr", "DK-Sor"/)

type                    = "png" 
;type                    = "x11"

;delete(wksb)
;delete(wksy)
;;delete(resy)


pnlres                = True
pnlres@gsnPanelDebug  = True
pnlres@gsnMaximize    = True   ; Maximize in frame
;pnlres@gsnFrame       = False  ; Don't advance frame.
;pnlres@gsnDraw        = False  ; Don't advance frame.
;pnlres@gsnPanelBottom = 0.13   ; Leave room for labelbar
pnlres@gsnPanelMainFontHeightF  = 0.025
   
wksp                       = gsn_open_wks (type,"PANEL")
wksp1 = wksp

do it = 0,14
   pnlres@gsnPanelMainString  =  codes1(it);+"_"+rcps(rt)           ; set main title
   gsn_panel(wksp, (/plot_2p6(it),x_plot_avg_2p6(it)/),(/1,2/),pnlres)               ; now draw as one plot

   pnlres@gsnPanelMainString  =  codes1(it);+"_"+rcps(rt)           ; set main title
   gsn_panel(wksp1, (/plot_6p0(it),x_plot_avg_6p0(it)/),(/1,2/),pnlres)               ; now draw as one plot

end do

end
