load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

; Script Time
begTime = get_cpu_time()

;--------------------------------------------------------
; Reads all files

;---------      0      1      2

compounds = (/"t2m", "WS",  "RH"/)

;A)START --------- LOOP OVER THE COMPOUNDS ----------------------
do it=0,2

   dir  = "./"+compounds(it)+"/"   ; input

;DEBUG
print("Working on folder "+compounds(it))     
;exit

  files  = systemfunc("cd "+dir+" && ls *")
  nfiles = dimsizes(files)

;DEBUG
;print(files)
;print(nfiles)
;exit

;B)START --------- LOOP OVER THE STATIONS ----------------------
      do ft=0,nfiles-1

;DEBUG
print(ft+"/"+nfiles+" Working on folder "+compounds(it)+" for "+files(ft))     
;exit

;---------> Read the files 
      station = asciiread(dir+files(ft),-1,"string")

;DEBUG
;printVarSummary(station)
;print(station)
;exit

      str   = str_split_csv (station, ",",3)

;DEBUG
;printVarSummary(str)
;print(str)
;exit

      conc       = tofloat(str(1::,5)) ; Kelvin
      conc@_FillValue = -999

;DEBUG
;printVarSummary(conc)
;print(conc)
;exit

      units      = (str(1,4))
      units@_FillValue = -999

;DEBUG
;printVarSummary(units)
;print(units)
;exit

;---------> Read Time files

       year     = tofloat(str(1::,0))
       month    = tofloat(str(1::,1))
       day      = tofloat(str(1::,2))
       hour     = tofloat(str(1::,3))
       
       ndates = dimsizes(day)

       minute   = new(ndates,float)
       minute   = 00

       second   = new(ndates,float)
       second   = 00

;DEBUG
;print(year)
;print(month)
;print(day)
;print(hour)
;print(minute)
;print(second)
;print("=============================")
;print(year+"_"+month+"_"+day+"_"+hour+"_"+minute+"_"+second)
;exit

;
;     csv_filename = dirB+"/"+eol_code+"_"+avg_time+".csv"
;     system("rm -rf " + csv_filename)               ; Remove file in case it exists.
;
;     nday = dimsizes(start_time)
;  
;;D)START --------- LOOP OVER THE DAYS/HOURS ----------------------
;     do dt=0,nday-1
;         format = "%s,%s,%s,%6.2f"           ; Format to use for each variable.
;         alist  = [/start_time(dt),end_time(dt),units(dt),conc(dt)/]
;         write_table(csv_filename, "a", alist, format)
;     end do
;;D)STOP --------- LOOP OVER THE DAYS/HOURS ----------------------
;
;
;--------> Useful to have the loops
delete(station)
delete(str)
delete(conc)
delete(units)

;--------> Useful to have the loops
;delete(files)
;delete(nfiles)

;--------> Useful to have the % of memory used
;psrep=systemfunc("ps u") 
;print (psrep) 
;delete(psrep) 

   end do
;B)STOP --------- LOOP OVER THE YEARS ----------------------

end do
;A)STOP --------- LOOP OVER THE COMPOUNDS ----------------------

; Script Time
print("Calculated PI in " + (get_cpu_time() - begTime) + " seconds")

end

