load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"      ; These two libraries are automatically
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"    ; loaded from NCL V6.4.0 onward.
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRF_contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/contrib/time_axis_labels.ncl"

;----------------------------------------------------------------------
; This function combines two date arrays that are assumed to have
; the same units and calendar.
;----------------------------------------------------------------------
function combine_dates(date1,date2)
begin
;
; This code makes sure you span the full range of both
; dates and that you cover any gaps in the middle.
;
  min_date = min((/min(date1),min(date2)/))
  max_date = max((/max(date1),max(date2)/))
  new_date = ispan(toint(min_date),toint(max_date),1)
  new_date@units    = date1@units
  new_date@calendar = date1@calendar
  return(new_date)
end

begin
;1)******************** Declaration Variables  ******************************************

type = "x11"
;type = "png"

compound = (/"DUST_1", "DUST_2", "DUST_3", "DUST_4", "DUST_5"/)

lat = 78.92
lon = 11.92

sampling = "ONE_S2_NYA"
camp     = "NY_1"

comp = "dust"

;2)******************** READ WRF-CSV ******************************************
;------------------ Density
fln = "ALT.csv"

linesa  = asciiread (fln, -1, "string")  ; -1 means read whole file
stra   = str_split_csv (linesa, ",", 0)
alt    = tofloat(stra(:,1))

;DEBUG
;print(stra)
;print(alt)
;exit

;-------------------- Time data WRF 
     flnm = compound(0)+".csv"
 
     lines  = asciiread (flnm, -1, "string")  ; -1 means read whole file
  
     str   = str_split_csv (lines, ",", 0)
     nums   = tofloat (str)                    ; _FillValue = 9.96921e+36

;DEBUG
;print(lines)                               ; echo input
;print(str)                               ; echo input
;exit
 
      delim = ","
      nfields = str_fields_count(lines(0), delim)   ; Count the fields separated
                                              ; by one or more spaces.
      field = 1
      subStrings = str_get_field(lines, field, delim)
;      print(subStrings)              ; (/2020-11-28_12:00:00/)

      year = toint(str_get_cols(subStrings, 0, 3))
;      print(year)                   ; (/"2003","2003","2003","2003"/)

      month = toint(str_get_cols(subStrings, 5, 6))
;      print(month)                  ; (/"06","06","06","06"/)

      day = toint(str_get_cols(subStrings, 8, 9))
;      print(day)                    ; (/13,13,12,12/)

      hour = toint(str_get_cols(subStrings, 11, 12))
;      print(hour)                   ; (/2,2,23,23)

;DEBUG
;print("=============================")
;print(year+"_"+month+"_"+day+"_"+hour)
;exit

;  Convert dates on CSV file to same units/calendar as WRF file
      ndates = dimsizes(hour)
      minute = new(ndates,integer)
      second = new(ndates,double)
      minute = 0
      second = 0

      opt = 1
      opt@calendar = "standard"
      units = "hours since 2020-08-01 00:00:00"
      csv_time = cd_inv_calendar(year,month,day,hour,minute,second,units,opt)

;-------------------- NY Time data ----------------------------------------------- 
     flnm1 = camp+".csv"

     lines1  = asciiread (flnm1, -1, "string")  ; -1 means read whole file

     str1   = str_split_csv (lines1, ",", 0)
  ;   nums1   = tofloat (str1)                    ; _FillValue = 9.96921e+36

;DEBUG
;print(lines1)                               ; echo input
;print(str1)                               ; echo input
;exit

      year1 = tofloat((str1(1::,2)))
;      print(year1)                   ; (/"2003","2003","2003","2003"/)

      month1 = tofloat((str1(1::,0)))
;      print(month1)                  ; (/"06","06","06","06"/)

      day1 = tofloat((str1(1::,1)))
;      print(day1)                    ; (/13,13,12,12/)

;  Convert dates on CSV file to same units/calendar as WRF file
      ndates1 = dimsizes(day1)
      hour1   = new(ndates1,double)
      minute1 = new(ndates1,double)
      second1 = new(ndates1,double)
      hour1 = 0
      minute1 = 0
      second1 = 0

;DEBUG
;print("=============================")
;print(year1+"_"+month1+"_"+day1+"_"+hour1+"_"+second1)
;exit

     csv_time1 = cd_inv_calendar(year1,month1,day1,hour1,minute1,second1,units,opt)


;  Combine dates on CSV file to same units/calendar as WRF file
     axis_date = combine_dates(csv_time,csv_time1)

;-------------------- NY data ----------------------------------------------- 

      dust1      = toint((str1(1::,10)))
      dust_title = tostring((str1(0,10)))
      head     = (/"DUST_1", "DUST_2", "DUST_3", "DUST_4", "DUST_5", "TOTDUST",dust_title/)

;DEBUG
;print(dust1)
;exit

;4) ***************************** Workstation settings *****************************

  wks = gsn_open_wks(type, sampling+"_"+comp) ; send graphics to PNG file

;---Plotting options for time series plot
  res             = True
  
  res@gsnMaximize = True
  
  res@gsnDraw     = False      ; Will draw later, after overlaying
  res@gsnFrame    = False      ; all plots
  
  res@vpWidthF    = 0.8        ; Make plots wider
  res@vpHeightF   = 0.4
  
  res@trXMinF     = min(csv_time)
  res@trXMaxF     = max(csv_time1)
  res@trYMinF     = 0
  res@trYMaxF     = 12
  
  ;------Grid lines
  res@tmXMajorGrid          = True               ; Add white grid lines
  res@tmXMajorGridLineColor = "black"
  res@tmYMajorGrid          = True
  res@tmYMajorGridLineColor = "black"
  res@tmYMajorGridLineDashPattern = 4
  res@tmXMajorGridLineDashPattern = 4
  res@tmXMajorGridThicknessF = 1
  res@tmYMajorGridThicknessF = 1


  ;---Resources for legend
  res@pmLegendDisplayMode    = "Always"              ; turn on legend
  res@pmLegendWidthF         = 0.12                  ; Change width and
  res@pmLegendHeightF        = 0.15                  ; height of legend.
  res@lgLabelFontHeightF     = .012                  ; change font height
  res@lgPerimOn              = False                 ; no box around

  ;---Titles
  res@tiMainString      = year+"_"+sampling+"_"+"["+"Lat="+lat+";"+"Lon="+lon+"]"             ; add title
  res@tmYLLabelFontHeightF   = 0.015   ; Increase font height
  res@tmXBLabelFontHeightF   = 0.015   ; Increase font height
  res@tiXAxisFontHeightF     = 0.015
  res@tiYAxisString          = "[ug m^-3]"
  res@tiXAxisString          = "Time"

  ;---Turn off some tickmarks
  res@tmXTOn                 = False    ; bottom off
  res@tmYROn                 = False    ; right off

  res@xyLineThicknessF       = 2.5      ; default is 1

  ;---Set resources for colors and labels
  colors  =   (/"blue","red","darkgreen","darkorange","brown","purple","black"/)
  position =  (/0.1, 0.40 ,0.70 ,0.10 ,0.40 ,0.70 ,0.10 ,0.40 ,0.70/)
  position1 = (/0.0,  0.0  ,0.0  ,0.10 ,0.10 ,0.10 ,0.20 ,0.20 ,0.20/)

;--------------------------------------------------
; The time_axis_label function adds additional
; resources to "res" to produce nicely-formatted
; time labels on X axis. This function only works
; if you have a time "units" recognized by the
; cd_calendar function.
;---------------------------------------------------
  restick                     = True
  restick@ttmFormat           = "%n/%d"
  restick@ttmMajorStride      =  30
  restick@ttmMinorStride      =   3

  time_axis_labels(csv_time,res,restick)

;---Create the four XY plots
  plot = new(7, graphic)

;DEBUG
;print(plot)
;print(head)
;exit

;START --------- LOOP OVER THE WV ----------------------
  do it=0,4

      flnmd   = compound(it)+".csv"
      ;print(flnmd)
      linesd  = asciiread(flnmd, -1, "string")  ; -1 means read whole file
      ;print(linesd)
      strd    = str_split_csv (linesd, ",", 0)
      ;print(strd)
      dust    = tofloat(strd(:,1))
      ;print(dust)

;DEBUG
;print(compound(it))
;print(dust)
;exit

      x = dust/alt  ; [ug m-3]    

;DUST
;print(x)
;exit

        ;-----------Create the four XY plots
      res@xyLineColors             = colors(it)
      res@xyExplicitLegendLabels   = head(it)
      res@xyMarkLineMode           = "MarkLines"
      res@xyMarker                 = 1
      res@xyMarkerColor            = colors(it)
      res@pmLegendParallelPosF     = position(it)
      res@pmLegendOrthogonalPosF   = position1(it)

      if (it .eq. 0) then
      x0 = x
      plot(it) = gsn_csm_xy(wks,csv_time,x0,res)
      end if 
      if (it .eq. 1) then
      x1 = x
      plot(it) = gsn_csm_xy(wks,csv_time,x1,res)
      end if 
      if (it .eq. 2) then
      x2 = x
      plot(it) = gsn_csm_xy(wks,csv_time,x2,res)
      end if 
      if (it .eq. 3) then
      x3 = x
      plot(it) = gsn_csm_xy(wks,csv_time,x3,res)
      end if 
      if (it .eq. 4) then
      x4 = x
      plot(it) = gsn_csm_xy(wks,csv_time,x4,res)
      end if 

delete(flnmd ) 
delete(linesd)
delete(strd  ) 
delete(dust  ) 

  end do
;exit

  xtot = x0+x1+x2+x3+x4
  ;res@trYMaxF     = max(xtot)
  
  ;-----------Create the four XY plots
  res@xyLineColors             = colors(5)
  res@xyMarkerColor            = colors(5)
  res@xyExplicitLegendLabels   = head(5)
  res@pmLegendParallelPosF     = position(5)
  res@pmLegendOrthogonalPosF   = position1(5)
  plot(5) = gsn_csm_xy(wks,csv_time,xtot,res)

;DEBUG
;print(x0)
;print(x1)
;print(x2)
;print(x3)
;print(x4)
;print(xtot)
;exit

  ;-----------Create the four XY plots
  res@xyLineColors             = colors(6)
  res@xyMarkerColor            = colors(6)
  res@xyExplicitLegendLabels   = head(6)
  res@pmLegendParallelPosF     = position(6)
  res@pmLegendOrthogonalPosF   = position1(6)
  plot(6) = gsn_csm_xy(wks,csv_time1,dust1,res)

  overlay(plot(0),plot(1))
  overlay(plot(0),plot(2))
  overlay(plot(0),plot(3))
  overlay(plot(0),plot(4))
  overlay(plot(0),plot(5))
  overlay(plot(0),plot(6))
  
  draw(plot(0))            ; This will draw all four plots
  frame(wks)

end
