load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"      ; These two libraries are automatically
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"    ; loaded from NCL V6.4.0 onward.
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRF_contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/contrib/time_axis_labels.ncl"


;----------------------------------------------------------------------
; This function combines two date arrays that are assumed to have
; the same units and calendar.
;----------------------------------------------------------------------
function combine_dates(date1,date2)

begin
;
; This code makes sure you span the full range of both
; dates and that you cover any gaps in the middle.
;
  min_date = min((/min(date1),min(date2)/))
  max_date = max((/max(date1),max(date2)/))
  new_date = ispan(toint(min_date),toint(max_date),1)
  new_date@units    = date1@units
  new_date@calendar = date1@calendar
  return(new_date)
end

;--------------------------------------------------------

begin



;1.a) ************************************************************************
; Reads all files

      files  = systemfunc("ls aeronet*")
      nfiles = dimsizes(files)

;print(files)
;exit


;B)START --------- LOOP OVER THE STATIONS ----------------------
      do ft=0,nfiles-1

plots2 = new(4,graphic)
;print(" Working on "+files(ft))     
;exit

;---------> Read the files 
         station = asciiread(files(ft),-1,"string")

;DEBUG
;printVarSummary(station)
;print(station)
;exit
      
         str   = str_split_csv (station, ",",-1)

;DEBUG
;printVarSummary(str)
;print(str)
;print(ncol)
;exit

;---------> Read Time file EBAS

         month  = tofloat(str(1::,0))
         day    = tofloat(str(1::,1))
         hour   = tofloat(str(1::,2))
         minute = tofloat(str(1::,3))
         second = tofloat(str(1::,4))
         
         ndates = dimsizes(hour)
 
         year     = new(ndates,integer)
         year     = 2021

;DEBUG
;print(year)
;print(month)
;print(day)
;print(hour)
;print(minute)
;print(second)
;print("=============================")
;print(year+"_"+month+"_"+day+"_"+hour+"_"+minute+"_"+second)
;exit

;1.b)----------------> WRF file CL_00 
         tst_alpha = str_split_by_length(files(ft), 4)
         alpha = stringtocharacter(tst_alpha)

;print(tst_alpha)
;exit
          test     = systemfunc("ls *wrf_00.csv")
;print(test)
;exit
          cnConst = str_match(test, tst_alpha(2))
;print(cnConst)
;exit

          WRF_file = asciiread(cnConst, -1, "string")          
;print(WRF_file)                               ; echo input
;exit
 
           str2    = str_split_csv (WRF_file, ",", 0)

           aod     = tofloat(str2(:,3))
          
;DEBUG
;print(aod)
;exit 
 
;---------> Read Time file WRF

         month1  = tofloat(str2(:,0))
         day1    = tofloat(str2(:,1))
         hour1   = tofloat(str2(:,2))
         
         ndates1 = dimsizes(hour1)
 
         year1     = new(ndates1,integer)
         year1     = 2021
         minute1   = new(ndates1,float)
         minute1   = 00
         second1  = new(ndates1,float)
         second1   = 00

;DEBUG
;print(year1  )  
;print(month1 )
;print(day1   )
;print(hour1  )
;print(minute1)
;print(second1)
;print("=============================")
;print(year1+"_"+month1+"_"+day1+"_"+hour1+"_"+minute1+"_"+second1)
;exit

;1.c)----------------> WRF file CL_11 

          test1     = systemfunc("ls *wrf_11.csv")
;print(test1)
;exit
          cnConst1  = str_match(test1, tst_alpha(2))
;print(cnConst1)
;exit

          WRF_file1 = asciiread(cnConst1, -1, "string")          
;print(WRF_file)                               ; echo input
;exit
 
           str21   = str_split_csv (WRF_file1, ",", 0)

           aod1    = tofloat(str21(:,3))
          
;DEBUG
;print(aod1)
;exit 
 
;---------> Read Time file WRF

         month11  = tofloat(str21(:,0))
         day11    = tofloat(str21(:,1))
         hour11   = tofloat(str21(:,2))
         
         ndates11 = dimsizes(hour11)
 
         year11     = new(ndates11,integer)
         year11     = 2021
         minute11   = new(ndates11,float)
         minute11   = 00
         second11   = new(ndates11,float)
         second11   = 00

;DEBUG
;print(year11  )  
;print(month11 )
;print(day11   )
;print(hour11  )
;print(minute11)
;print(second11)
;print("=============================")
;print(year11+"_"+month11+"_"+day11+"_"+hour11+"_"+minute11+"_"+second11)
;exit

;2) **********************************************************************
;Convert dates on CSV file to same units/calendar as WRF file
         opt = 1
         units  = "hours since 1900-01-01 00:00:00" ; "seconds/hours/days since ...."
         csv_time  = cd_inv_calendar (year,month,day,hour,minute,second,units,opt)
         csv_time1 = cd_inv_calendar(year1,month1,day1,hour1,minute1,second1,units,opt)
         csv_time11= cd_inv_calendar(year11,month11,day11,hour11,minute11,second11,units,opt)

         ;---Combine the two date arrays for a single date array for the X axis labels.
         axis_date  = combine_dates(csv_time,csv_time1)
         axis_date1 = combine_dates(csv_time,csv_time11)


;DEBUG
;print(axis_date)
;print(csv_time)
;print(csv_time1)
;print(csv_time11)
;exit

;3) ************************************************************************
; Workstation settings

       ; type ="png"
        type ="x11"
        wks = gsn_open_wks(type,files(ft)) ; send graphics to PNG file

        ;---Plotting options for time series plot
          res             = True
        
          res@gsnMaximize = True
        
          res@gsnDraw     = False      ; Will draw later, after overlaying
          res@gsnFrame    = False      ; all plots
 
          res@vpWidthF    = 0.8        ; Make plots wider
          res@vpHeightF   = 0.4
        
          res@trXMinF     = min(csv_time1)
          res@trXMaxF     = max(csv_time1)
          res@trYMaxF     = max(aod)
          res@trYMinF     = 0

          
          ;---Resources for legend
          res@pmLegendDisplayMode    = "Always"              ; turn on legend
          res@pmLegendWidthF         = 0.12                  ; Change width and
          res@pmLegendHeightF        = 0.15                  ; height of legend.
          res@lgLabelFontHeightF     = .012                  ; change font height
          res@lgPerimOn              = False                 ; no box around
        
          ;---Titles
          res@tmYLLabelFontHeightF   = 0.01   ; Increase font height
          res@tmXBLabelFontHeightF   = 0.01   ; Increase font height
          res@tiXAxisFontHeightF     = 0.015 
          res@tiYAxisString          = "AOD"
        
          ;---Turn off some tickmarks
          res@tmXTOn                 = False    ; bottom off
          res@tmYROn                 = False    ; right off
        
          res@xyLineThicknessF       = 2.5      ; default is 1
        
        ;--------------------------------------------------
        ; The time_axis_label function adds additional
        ; resources to "res" to produce nicely-formatted
        ; time labels on X axis. This function only works
        ; if you have a time "units" recognized by the
        ; cd_calendar function.
        ;---------------------------------------------------
          restick                     = True
          restick@ttmFormat           = "%d"
          restick@ttmMajorStride      = 24 ;30
          restick@ttmMinorStride      =  2 ;6
          
          time_axis_labels(csv_time1,res,restick)


;DEBUG
;print(plot)
;print(head)
;exit

;C)START --------- LOOP OVER THE WV ----------------------
                  aod_csv = tofloat(str(1::,5))
                  aod_csv@_FillValue = -999
                  head   = str(0,5) 
;DEBUG
;print(aod_csv) 
;print(head) 
;exit

;---Create the four XY plots
plots = new(3, graphic)        

        ;-----------Create the four XY plots
              res@xyMarkerColor             = "black"
              res@xyMarkLineMode           = "Markers" 
              res@xyMarker                 = 9
              res@xyExplicitLegendLabels   = head
              res@pmLegendDisplayMode = "NoCreate"
              res@pmLegendParallelPosF     = 0.2 ;position(0)
              res@pmLegendOrthogonalPosF   = 0.0 ;position1(0)
              plots(0) = gsn_csm_xy(wks,csv_time,aod_csv,res)
        
              res@xyMarkLineMode           = "Lines" 
              res@xyLineColor              = "black"
              res@xyExplicitLegendLabels   = "AOD_wrf_CL00 "
              res@pmLegendParallelPosF     = 0.5
              res@pmLegendOrthogonalPosF   = 0 
              plots(1) = gsn_csm_xy(wks,csv_time1,aod,res)

              res@xyExplicitLegendLabels   = "AOD_wrf_CL11 "
              res@xyLineColor              = "black"
              res@xyDashPattern            = 1
              res@pmLegendParallelPosF     = 0.8
              res@pmLegendOrthogonalPosF   = 0 
              plots(2) = gsn_csm_xy(wks,csv_time11,aod1,res)
              delete(res@xyMarkLineMode) 
              delete(res@xyDashPattern)

overlay(plots(0),plots(1))
overlay(plots(0),plots(2))

plots2(ft) = plots(0)
print(plots2)

delete(plots)
delete(str)
delete(station)
delete(month ) 
delete(day   ) 
delete(hour  ) 
delete(minute) 
delete(second) 
delete(year) 
delete(csv_time) 
delete(csv_time1) 
delete(csv_time11) 
delete(axis_date) 
delete(axis_date1) 
delete(aod_csv)
delete(tst_alpha)
delete(alpha)
delete(restick@ttmMajorStride);(axis_date,res,restick))
delete(restick@ttmMinorStride);(axis_date,res,restick))


;B)START --------- LOOP OVER THE STATIONS ----------------------
end do

panel_res = True
gsn_panel(wks,plots2,(/2,2/),panel_res)

end
