!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: swmpoperator
!
! !INTERFACE:
  subroutine swmpoperator (timein,&
                      latin,&
                      lonin,&
                      Tc_9_in,&
                      wb_t_in,&
                      tswmp80_out,&
                      tswmp65_out)

!
! !DESCRIPTION:
! Spitout those vars!
! !USES:
    use shr_kind_mod , only: r8 => shr_kind_r8
    use HumanIndexMod            , only : SwampCoolEff
!
! !ARGUMENTS:
    implicit none

    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8) :: Tc_9_in(lonin,latin,timein)        ! temperature (K)
    real(r8) :: wb_t_in(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: tswmp80_out(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: tswmp65_out(lonin,latin,timein)         ! surface atmospheric pressure (pa)

    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
            call SwampCoolEff(Tc_9_in(rss,pss,tss),&
                          wb_t_in(rss,pss,tss),&
                          tswmp80_out(rss,pss,tss),&
                          tswmp65_out(rss,pss,tss))
         end do
       end do
     end do

  end subroutine swmpoperator
