!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: swbgtoperator
!
! !INTERFACE:
  subroutine swbgtoperator (timein,&
                      latin,&
                      lonin,&
                      Tc_2_in,&
                      vap_pres_in,&
                      s_wbgt_out)

!
! !DESCRIPTION:
! Spitout those vars!
! !USES:
    use shr_kind_mod , only: r8 => shr_kind_r8
    use HumanIndexMod            , only : swbgt
!
! !ARGUMENTS:
    implicit none

    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8) :: Tc_2_in(lonin,latin,timein)        ! temperature (K)
    real(r8) :: vap_pres_in(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: s_wbgt_out(lonin,latin,timein)         ! surface atmospheric pressure (pa)

    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
            call swbgt(Tc_2_in(rss,pss,tss),&
                      vap_pres_in(rss,pss,tss),&
                      s_wbgt_out(rss,pss,tss))
         end do
       end do
     end do


  end subroutine swbgtoperator
