;;;;;;;;;;;;;;Function;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;		       Call in difference fields
;		       plot contours of world	
;;;;;;;;;;;;;Always Load your Libraries!!!;;;;;;;;;;;;;;
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/ccm_func.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/skewt_func.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;; Always nice to have a beginning!(and an end);;;;;

external QSATMODOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/QSatMod/qsatmodoperator.so"
external WETBULBOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/Wet_Bulb/wetbulboperator.so"
external THIOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/THIndex/thioperator.so"
external SWMPOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/SwampCoolEff/swmpoperator.so"
external HIOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/HeatIndex/hioperator.so"
external APPTEMPOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/HeatIndex/apptempoperator.so"
external DISCOIOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/HeatIndex/discoioperator.so"
external HMDEXOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/HeatIndex/hmdexoperator.so"
external SWBGTOPERATOR "/scratch/carter/j/jbuzan/fortran_routines/wrf_CCSM4_routines/HeatIndex/swbgtoperator.so"

begin
;;;;;;;;;;;;;;GENERAL PROPERTIES;;;;;;;;;;;;
;;;;;;;;;;;;;;;Case File Names;;;;;;;;;;;;;;
CasePRES = getenv("CASEPRES")
CaseRELHUM = getenv("CASERELHUM")
CaseTEMP = getenv("CASETEMP")
;;;;;;;;FILE Call INs;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;;;;;;;;If Q not in file, USE RH  go to line
    ;;;;;;;;MODIFYHERE FOR Q or RH Line 171;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CASEPres  = addfile(CasePRES,"r")
;CASERelhum  = addfile(CaseRELHUM,"r")
;CASETemp  = addfile(CaseTEMP,"r")

;CASEPres  = addfile("/scratch/conte/j/jbuzan/file_analysis/PSurf/I.MO.07_0_cru_x1_120_wb.stride.clm2.h1.1901.PSurf.nc","r")
printVarSummary(CASEPres)
;CASERelhum  = addfile("/scratch/conte/j/jbuzan/file_analysis/RH2M/I.MO.07_0_cru_x1_120_wb.stride.clm2.h1.1901.RH2M.nc","r")
;printVarSummary(CASERelhum)
;CASETemp  = addfile("/scratch/conte/j/jbuzan/file_analysis/TSA/I.MO.07_0_cru_x1_120_wb.stride.clm2.h1.1901.TSA.nc","r")
;printVarSummary(CASETemp)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Call In Variables;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Tfloat = CASEPres->T2
;Tfloat = CASETemp->T2
TSA1 = flt2dble(Tfloat)
TSA = (/TSA1/)
;TSA = Tfloat
printVarSummary(TSA)
delete(Tfloat)
delete(TSA1)

RHfloat = CASEPres->Q2
;RHfloat = CASERelhum->Q2
Q2M1 = flt2dble(RHfloat)
Q2M = (/Q2M1/)
;RH2M = RHfloat
;printVarSummary(RH2M)
delete(RHfloat)
delete(Q2M1)

pfloat = CASEPres->PSFC
;pfloat = CASEPres->PSFC
PSurf1 = flt2dble(pfloat)
PSurf = (/PSurf1/)
;PSurf = pfloat
printVarSummary(PSurf)
delete(pfloat)
delete(PSurf1)

ufloat = CASEPres->U10
U101 = flt2dble(ufloat)
U10 = (/U101/)
printVarSummary(U10)
delete(ufloat)
delete(U101)

;lon = new((/507/), "double")
;lon = CASETemp->lon
;lon!0 = "lon" 
;lon&lon = lon
printVarSummary(lon)

;lat = new((/414/), "double")
lat = CASETemp->lat
;lat!0 = "lat" 
;lat&lat = lat
printVarSummary(lat)

;time = new((/112/), "double")
time = CASETemp->time
;time!0 = "time" 
;time&time = time
printVarSummary(time)

TSA!0 = "time"
TSA&time = time
TSA!1 = "lat"
TSA&lat = lat
TSA!2 = "lon"
TSA&lon = lon
printVarSummary(TSA)

Q2M!0 = "time"
Q2M&time = time
Q2M!1 = "lat"
Q2M&lat = lat
Q2M!2 = "lon"
Q2M&lon = lon
printVarSummary(Q2M)

PSurf!0 = "time"
PSurf&time = time
PSurf!1 = "lat"
PSurf&lat = lat
PSurf!2 = "lon"
PSurf&lon = lon
printVarSummary(PSurf)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Manpulate Variables;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Reorder Dimensions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Generate Tglobe and Trad;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
value = 1d+20

numarray = new((/dimsizes(time),dimsizes(lat),dimsizes(lon)/),"double")
;numarray = new((/dimsizes(lon),dimsizes(lat),dimsizes(time)/),"double")
numarray@_FillValue = value
numarray!0 = "time" 
numarray!1 = "lat" 
numarray!2 = "lon"
numarray&time = time
numarray&lat = lat
numarray&lon = lon

numarray = numarray@_FillValue

ES = numarray
printVarSummary(ES)

ESDT = numarray
printVarSummary(ESDT)

QS = numarray
printVarSummary(QS)

QSDT = numarray
printVarSummary(QSDT)
    
    QSATMODOPERATOR::qsatmodoperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA,\
			     PSurf,\
			     ES,\
			     ESDT,\
			     QS,\
			     QSDT)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Reorder Dimensions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VAPORPRESS = numarray
VAPORPRESSDIFF = numarray
VAPORPRESSSAT = numarray
;;;;MODIFYHERE FOR Q or RH Line 171;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
VAPORPRESSSAT = ES
delete(ES)   

RH2M = Q2M
RH2M = Q2M/QS * 100.d

VAPORPRESS = VAPORPRESSSAT*RH2M*0.01d

VAPORPRESSDIFF = VAPORPRESS - VAPORPRESSSAT
delete(VAPORPRESSSAT)   
delete(QSDT)   
delete(QS)   


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Wet Bulb;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TEQ = numarray
printVarSummary(TEQ)
    
EPT = numarray
printVarSummary(EPT)
    
WBA = numarray
printVarSummary(WBA)
    
    WETBULBOPERATOR::wetbulboperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA,\
			     VAPORPRESS,\
			     PSurf,\
			     RH2M,\
			     Q2M,\
			     TEQ,\
			     EPT,\
			     WBA)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;THI;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TSA2 = TSA 
TSA2 = TSA - 273.15d

THIP = numarray
printVarSummary(THIP)
    
THIC = numarray
printVarSummary(THIC)
    
    THIOPERATOR::thioperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     WBA,\
			     THIP,\
			     THIC)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;SWMP;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SWMP80 = numarray
printVarSummary(SWMP80)
    
SWMP65 = numarray
printVarSummary(SWMP65)
    
    SWMPOPERATOR::swmpoperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     WBA,\
			     SWMP80,\
			     SWMP65)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;HI;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
HIA = numarray
printVarSummary(HIA)
    
    HIOPERATOR::hioperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     RH2M,\
			     HIA)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;sWBGT;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sWBGT = numarray
printVarSummary(sWBGT)
    
    SWBGTOPERATOR::swbgtoperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     VAPORPRESS,\
			     sWBGT)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;DISCOI;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DI = numarray
printVarSummary(DI)
    
    DISCOIOPERATOR::discoioperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     WBA,\
			     DI)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;APPTEMP;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AT = numarray
printVarSummary(AT)
    
    APPTEMPOPERATOR::apptempoperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     VAPORPRESS,\
			     U10,\
			     AT)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;HUMIDEX;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
HUMIDEX = numarray
printVarSummary(HUMIDEX)
    
    HMDEXOPERATOR::hmdexoperator(dimsizes(time),\
	                     dimsizes(lat),\
			     dimsizes(lon),\
			     TSA2,\
			     VAPORPRESS,\
			     HUMIDEX)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;FillValues;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;Output_Data;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
outputdataMASTER = getenv("OUTPUTDATAMASTER")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
system("rm -f "+outputdataMASTER)
outmaster = addfile(outputdataMASTER, "c")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ntim  = dimsizes(time)                 ; get dimension sizes  
	nlat  = dimsizes(lat)  
	nlon  = dimsizes(lon)      

setfileoption(outmaster,"DefineMode",True)
fAtt               = True            ; assign file attributes
	fAtt@title         = "Vapor_Pres_Related_Data_CRUNCEP_CLM4.5_Run"  
	fAtt@source_file   =  "original-file.nc"
	fAtt@Conventions   = "None"   
	fAtt@creation_date = systemfunc ("date")        
	fileattdef( outmaster, fAtt )            ; copy file attributes    
dimNames = (/"time", "lat", "lon"/)  
	dimSizes = (/ -1   ,  nlat,  nlon /) 
	dimUnlim = (/ True , False, False/)   
	filedimdef(outmaster,dimNames,dimSizes,dimUnlim)
filevardef(outmaster, "time" ,typeof(time),getvardims(time)) 
       filevardef(outmaster, "lat"  ,typeof(lat),getvardims(lat))                          
       filevardef(outmaster, "lon"  ,typeof(lon),getvardims(lon))                          
       filevardef(outmaster, "TSA"    ,typeof(TSA)  ,getvardims(TSA))    
       filevardef(outmaster, "U10"   ,typeof(U10) ,getvardims(U10))          
       filevardef(outmaster, "PSurf"   ,typeof(PSurf) ,getvardims(PSurf))          
       filevardef(outmaster, "VAPORPRESS",typeof(VAPORPRESS),getvardims(VAPORPRESS))
       filevardef(outmaster, "RH2M",typeof(RH2M),getvardims(RH2M))
       filevardef(outmaster, "TEQ",typeof(RH2M),getvardims(TEQ))
       filevardef(outmaster, "EPT",typeof(EPT),getvardims(EPT))
       filevardef(outmaster, "WBA",typeof(WBA),getvardims(WBA))
       filevardef(outmaster, "THIC",typeof(THIC),getvardims(THIC))
       filevardef(outmaster, "THIP",typeof(THIP),getvardims(THIP))
       filevardef(outmaster, "SWMP80",typeof(SWMP80),getvardims(SWMP80))
       filevardef(outmaster, "SWMP65",typeof(SWMP65),getvardims(SWMP65))
       filevardef(outmaster, "HIA",typeof(HIA),getvardims(HIA))
       filevardef(outmaster, "sWBGT",typeof(sWBGT),getvardims(sWBGT))
       filevardef(outmaster, "DI",typeof(DI),getvardims(DI))
       filevardef(outmaster, "AT",typeof(AT),getvardims(AT))
       filevardef(outmaster, "HUMIDEX",typeof(HUMIDEX),getvardims(HUMIDEX))


filevarattdef(outmaster,"TSA",TSA)                           ; copy T attributes
       filevarattdef(outmaster,"time" ,time)                    ; copy time attributes
       filevarattdef(outmaster,"lat"  ,lat)                     ; copy lat attributes
       filevarattdef(outmaster,"lon"  ,lon)                     ; copy lon attributes
       filevarattdef(outmaster,"U10"   ,U10)                      ; copy PS attributes
       filevarattdef(outmaster,"PSurf"   ,PSurf)                      ; copy PS attributes
       filevarattdef(outmaster,"VAPORPRESS",VAPORPRESS)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"RH2M",RH2M)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"TEQ",TEQ)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"EPT",EPT)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"WBA",WBA)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"THIP",THIP)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"THIC",THIC)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"SWMP80",SWMP80)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"SWMP65",SWMP65)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"HIA",HIA)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"sWBGT",sWBGT)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"DI",DI)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"AT",AT)                     ; copy TOPOG attributes
       filevarattdef(outmaster,"HUMIDEX",HUMIDEX)                     ; copy TOPOG attributes

setfileoption(outmaster,"DefineMode",False)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
printVarSummary(outmaster)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
outmaster->time   = (/time/)     
outmaster->lat    = (/lat/)
outmaster->lon    = (/lon/)

outmaster->TSA = (/TSA/)
outmaster->U10 = (/U10/)
outmaster->PSurf = (/PSurf/)
outmaster->VAPORPRESS = (/VAPORPRESS/)
outmaster->RH2M = (/RH2M/)

outmaster->TEQ = (/TEQ/)
outmaster->EPT = (/EPT/)
outmaster->WBA = (/WBA/)

outmaster->THIP = (/THIP/)
outmaster->THIC = (/THIC/)

outmaster->SWMP80 = (/SWMP80/)
outmaster->SWMP65 = (/SWMP65/)

outmaster->HIA = (/HIA/)
outmaster->sWBGT = (/sWBGT/)
outmaster->DI = (/DI/)
outmaster->AT = (/AT/)
outmaster->HUMIDEX = (/HUMIDEX/)


end
