!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: hmdexoperator
!
! !INTERFACE:
  subroutine hmdexoperator (timein,&
                      latin,&
                      lonin,&
                      Tc_4_in,&
                      vapor_in,&
                      hmdex_out)

!
! !DESCRIPTION:
! Spitout those vars!
! !USES:
    use shr_kind_mod , only: r8 => shr_kind_r8
    use HumanIndexMod            , only : hmdex
!
! !ARGUMENTS:
    implicit none

    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8) :: Tc_4_in(lonin,latin,timein)        ! temperature (K)
    real(r8) :: vapor_in(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: hmdex_out(lonin,latin,timein)         ! surface atmospheric pressure (pa)

    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
            call hmdex(Tc_4_in(rss,pss,tss),&
                      vapor_in(rss,pss,tss),&
                      hmdex_out(rss,pss,tss))
         end do
       end do
     end do

  end subroutine hmdexoperator
