!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: wetbulboperator
!
! !INTERFACE:
  subroutine wetbulboperator (timein,&
                      latin,&
                      lonin,&
                      T_kinp_1,&
                      vapep,&
                      p_tinp_1,&
                      relhump,&
                      qinp,&
                      Teqp,&
                      epottp,&
                      wb_itp)
!
! !DESCRIPTION:
! Spitout those vars!
! !USES:
    use shr_kind_mod , only: r8 => shr_kind_r8
    use HumanIndexMod            , only : Wet_Bulb
!
! !ARGUMENTS:
    implicit none

    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8) :: T_kinp_1(lonin,latin,timein)        ! temperature (K)
    real(r8) :: vapep(lonin,latin,timein)           ! surface atmospheric pressure (pa)
    real(r8) :: p_tinp_1(lonin,latin,timein)        ! surface atmospheric pressure (pa)
    real(r8) :: relhump(lonin,latin,timein)         ! vapor pressure (pa)
    real(r8) :: qinp(lonin,latin,timein)            ! d(es)/d(T) 
    real(r8) :: Teqp(lonin,latin,timein)            ! dln(es)/d(T)
    real(r8) :: epottp(lonin,latin,timein)          ! humidity (kg/kg)
    real(r8) :: wb_itp(lonin,latin,timein)          ! d(qs)/d(T)

    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
            call Wet_Bulb(T_kinp_1(rss,pss,tss),&
                          vapep(rss,pss,tss),&
                          p_tinp_1(rss,pss,tss),&
                          relhump(rss,pss,tss),&
                          qinp(rss,pss,tss),&
                          Teqp(rss,pss,tss),&
                          epottp(rss,pss,tss),&
                          wb_itp(rss,pss,tss))
         end do
       end do
     end do

  end subroutine wetbulboperator
