!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: qsatmodoperator
!
! !INTERFACE:
     subroutine qsatmodoperator (timein,&
                                latin,&
                                lonin,&
                                T_k_in,&
                                p_in,&
                                e_s_out,&
                                e_s_d_T_out,&
                                q_s_out,&
                                q_s_d_T_out)
      
! !DESCRIPTION:
! Spitout those vars!
! !USES:      
    use shr_kind_mod , only: r8 => shr_kind_r8
    use QSatMod , only: QSat
!
!
! !ARGUMENTS:
    implicit none
    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8), intent(in) :: T_k_in(lonin,latin,timein)        ! temperature (K)
    real(r8), intent(in) :: p_in(lonin,latin,timein)          ! surface atmospheric pressure (pa)
    real(r8), intent(out) :: e_s_out(lonin,latin,timein)       ! vapor pressure (pa)
    real(r8), intent(out) :: e_s_d_T_out(lonin,latin,timein)   ! d(es)/d(T) 
    real(r8), intent(out) :: q_s_out(lonin,latin,timein)       ! humidity (kg/kg)
    real(r8), intent(out) :: q_s_d_T_out(lonin,latin,timein)   ! d(qs)/d(T)
    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
                  call QSat (T_k_in(rss,pss,tss),&
                             p_in(rss,pss,tss),&
                             e_s_out(rss,pss,tss),&
                             e_s_d_T_out(rss,pss,tss),&
                             q_s_out(rss,pss,tss),&
                             q_s_d_T_out(rss,pss,tss))
         end do
       end do
     end do
      
  end subroutine qsatmodoperator
