!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: apptempoperator
!
! !INTERFACE:
  subroutine apptempoperator (timein,&
                      latin,&
                      lonin,&
                      Tc_in,&
                      vap_pres_in,&
                      u10_m_in,&
                      app_temp_out)

!
! !DESCRIPTION:
! Spitout those vars!
! !USES:
    use shr_kind_mod , only: r8 => shr_kind_r8
    use HumanIndexMod            , only : AppTemp
!
! !ARGUMENTS:
    implicit none

    integer, intent(in) :: timein
    integer, intent(in) :: latin
    integer, intent(in) :: lonin
    real(r8) :: Tc_in(lonin,latin,timein)        ! temperature (K)
    real(r8) :: vap_pres_in(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: u10_m_in(lonin,latin,timein)         ! surface atmospheric pressure (pa)
    real(r8) :: app_temp_out(lonin,latin,timein)         ! surface atmospheric pressure (pa)

    integer tss,pss,rss

     do tss=1,timein
       do pss=1,latin
         do rss=1,lonin
            call AppTemp(Tc_in(rss,pss,tss),&
                      vap_pres_in(rss,pss,tss),&
                      u10_m_in(rss,pss,tss),&
                      app_temp_out(rss,pss,tss))
         end do
       end do
     end do

  end subroutine apptempoperator
