load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

; READ CONTROL FILES 
fils := systemfunc ("ls stat_control_p_*_lower_NH_neg.nc") ; file paths
f    := addfiles (fils, "r")  
; read
ListSetType (f, "join")
lat   = f[0]->lat
lon   = f[0]->long
lat@units="degrees_north"
lon@units="degrees_east"

intensity_control  = f[:]->mstr
lifetime_control   = f[:]->mlif
meanspeed_control  = f[:]->msp
growthrate_control = f[:]->mgdr

intensity_control!1="lat"
intensity_control!2="lon"
intensity_control&lat = lat 
intensity_control&lon = lon
lifetime_control!1="lat"
lifetime_control!2="lon"
lifetime_control&lat = lat 
lifetime_control&lon = lon
meanspeed_control!1="lat"
meanspeed_control!2="lon"
meanspeed_control&lat = lat 
meanspeed_control&lon = lon
growthrate_control!1="lat"
growthrate_control!2="lon"
growthrate_control&lat = lat 
growthrate_control&lon = lon

; READ RETROGRADE FILES 
fils := systemfunc ("ls stat_retrograde_p_*_lower_NH_neg.nc") ; file paths
f    := addfiles (fils, "r")  
; read
ListSetType (f, "join")

intensity_retrograde  = f[:]->mstr
lifetime_retrograde   = f[:]->mlif
meanspeed_retrograde  = f[:]->msp
growthrate_retrograde = f[:]->mgdr

delete([/fils, f/])

intensity_retrograde!1="lat"
intensity_retrograde!2="lon"
intensity_retrograde&lat = lat 
intensity_retrograde&lon = lon
lifetime_retrograde!1="lat"
lifetime_retrograde!2="lon"
lifetime_retrograde&lat = lat 
lifetime_retrograde&lon = lon
meanspeed_retrograde!1="lat"
meanspeed_retrograde!2="lon"
meanspeed_retrograde&lat = lat 
meanspeed_retrograde&lon = lon
growthrate_retrograde!1="lat"
growthrate_retrograde!2="lon"
growthrate_retrograde&lat = lat 
growthrate_retrograde&lon = lon

; CREATE ARRAYS FOR HISTOGRAM

area="atlantic"
if area.eq."NH" then 
lat_min=0
lat_max=90
lon_min=0
lon_max=360
else if area.eq."atlantic" then
lon_min=280
lon_max=360
lat_min=0
lat_max=60
else if area.eq."pacific"  then
lon_min=120
lon_max=260
lat_min=0
lat_max=60
else if area.eq."europe"  then
lon_min=-10
lon_max=30
lat_min=30
lat_max=70
end if 
end if 
end if 
end if 

intensity=(/ndtooned(intensity_control(:,{lat_min:lat_max},{lon_min:lon_max})),ndtooned(intensity_retrograde(:,{lat_min:lat_max},{lon_min:lon_max}))/)
lifetime=(/ndtooned(lifetime_control(:,{lat_min:lat_max},{lon_min:lon_max})),ndtooned(lifetime_retrograde(:,{lat_min:lat_max},{lon_min:lon_max}))/)
meanspeed=(/ndtooned(meanspeed_control(:,{lat_min:lat_max},{lon_min:lon_max})),ndtooned(meanspeed_retrograde(:,{lat_min:lat_max},{lon_min:lon_max}))/)
growthrate=(/ndtooned(growthrate_control(:,{lat_min:lat_max},{lon_min:lon_max})),ndtooned(growthrate_retrograde(:,{lat_min:lat_max},{lon_min:lon_max}))/)

delete([/intensity_control, lifetime_control, meanspeed_control, growthrate_control, intensity_retrograde, lifetime_retrograde, meanspeed_retrograde, growthrate_retrograde/])

intensity@long_name="Mean cyclone intensity [%]"
intensity@short_name="intensity"
lifetime@long_name="Mean cyclone lifetime [%]"
lifetime@short_name="lifetime"
meanspeed@long_name="Mean cyclone speed [%]"
meanspeed@short_name="speed"
growthrate@long_name="Mean cyclone growth/decay rate [%]"
growthrate@short_name="growthrate"


res=True
 res@gsnDraw=False
 res@gsnFrame=False
 res@tmXBLabelAngleF=90
 res@xyLineThicknessF = 5
 res@xyDashPattern = 0
 res@xyLineColors = (/"black","red"/)
 res@gsnXYBelowFillColors = "red"
res@vpHeightF = 0.4

  ; res@gsnYRefLineColor      = "transparent"
  ; res@gsnAboveYRefLineColor = "black"
  ; res@gsnYRefLine           = 0
 res@gsnXYFillOpacities = 0.1
res@tiYAxisFontHeightF = 0.015


res@pmLegendDisplayMode    = "Always"
res@pmLegendSide           = "Bottom"               ; Change location of 
res@pmLegendParallelPosF   = 0.85                 ; move units right
res@pmLegendOrthogonalPosF = -1               ; move units down
res@pmLegendWidthF         = 0.15                ; Change width and
res@pmLegendHeightF        = 0.1                ; height of legend.
res@lgLabelFontHeightF     = .01                 ; change font height         ; so it masks XY curves
res@lgOrientation          = "vertical"
res@lgPerimOn              = False               ; turn off box
res@xyExplicitLegendLabels = (/"CNTRL","RETRO"/)

lres = True 
lres@gsLineDashPattern = 1 
lres@gsLineThicknessF = 3

wks=gsn_open_wks("x11", "stats_"+area)

nclass=50
data=new((/2, nclass/), double)

var:=intensity
var=mask(intensity, intensity.le.0.5, False)

do j=0,1
 data(j,:)=pdfx(var(j,:), nclass,  False)
end do
 res@tiXAxisString ="[hPa]" 
 plot_intensity=gsn_csm_xy(wks,data@bin_center,data,res)
 xaxis:=data@bin_center
 lres@gsLineColor = "black" 
 line_mean=gsn_add_polyline(wks, plot_intensity,   (/avg(var(0,:)),avg(var(0,:))/) , (/0, data(0,closest_val(avg(var(0,:)), xaxis )) /), lres)
 lres@gsLineColor = "red"
 line_mean_2=gsn_add_polyline(wks, plot_intensity, (/avg(var(1,:)),avg(var(1,:))/) , (/0, data(1,closest_val(avg(var(1,:)), xaxis )) /), lres)

 var:=lifetime
 var=mask(lifetime, lifetime.lt.1 , False)
do j=0,1
 data(j,:)=pdfx(var(j,:), nclass,  False)
end do
 res@pmLegendDisplayMode    = "Never"
 res@tiXAxisString ="[days]"  
 plot_lifetime=gsn_csm_xy(wks,data@bin_center,data,res)
 xaxis:=data@bin_center
  lres@gsLineColor = "black" 
 line_mean_lifetime=gsn_add_polyline(wks, plot_lifetime,   (/avg(var(0,:)),avg(var(0,:))/) , (/0, data(0,closest_val(avg(var(0,:)), xaxis )) /), lres)
 lres@gsLineColor = "red"
 line_mean_2_lifetime=gsn_add_polyline(wks, plot_lifetime, (/avg(var(1,:)),avg(var(1,:))/) , (/0, data(1,closest_val(avg(var(1,:)), xaxis )) /), lres)

 var:=meanspeed
 var=mask(meanspeed, meanspeed.lt.1 , False)
do j=0,1
 data(j,:)=pdfx(var(j,:), nclass,  False)
end do 
 res@tiXAxisString ="[km h~S~-1~N~]"  
 plot_meanspeed=gsn_csm_xy(wks,data@bin_center,data,res)
 xaxis:=data@bin_center
  lres@gsLineColor = "black" 
 line_mean_meanspeed=gsn_add_polyline(wks, plot_meanspeed,   (/avg(var(0,:)),avg(var(0,:))/) , (/0, data(0,closest_val(avg(var(0,:)), xaxis )) /), lres)
 lres@gsLineColor = "red"
 line_mean_2_meanspeed=gsn_add_polyline(wks, plot_meanspeed, (/avg(var(1,:)),avg(var(1,:))/) , (/0, data(1,closest_val(avg(var(1,:)), xaxis )) /), lres)

 var:=growthrate
 var=var*24
do j=0,1
 data(j,:)=pdfx(var(j,:), nclass,  False)
end do
 res@tiXAxisString ="[days~S~-1~N~]"
 ; res@tiXAxisString ="[days]"
 res@trXMinF = -2.0
 res@trXMaxF =  1.0      
 plot_growthrate=gsn_csm_xy(wks,data@bin_center,data,res)
 xaxis:=data@bin_center
 lres@gsLineColor = "black" 
 line_mean_growthrate=gsn_add_polyline(wks, plot_growthrate,   (/avg(var(0,:)),avg(var(0,:))/) , (/0, data(0,closest_val(avg(var(0,:)), xaxis )) /), lres)
 lres@gsLineColor = "red"
 line_mean_2_growthrate=gsn_add_polyline(wks, plot_growthrate, (/avg(var(1,:)),avg(var(1,:))/) , (/0, data(1,closest_val(avg(var(1,:)), xaxis )) /), lres)

 pnlres=True 
 pnlres@gsnMaximize = True 
 pnlres@gsnPanelMainString="Area= "+area

 gsn_panel(wks, (/plot_intensity,plot_lifetime,plot_meanspeed,plot_growthrate/), (/2,2/), pnlres)
 

end



