DIR_DADOS = "../output/"
titulo    = (/"CMAP (1979-2016)","GPCP (1979-2016)","CRU (1979-2015)","LIEBMANN (1970-2015)","TRMM (1998-2015)"/)
fontes    = (/"cmap","gpcp","cru","liebmann","trmm"/)
estacao   = (/"MAM","JJA","SON","DJF"/)
nfig      = dimsizes(fontes)*dimsizes(estacao)

do i = 0,dimsizes(fontes)-1

	wks       = gsn_open_wks ("pdf","../figuras/sazonal.sem.defasagem")
	plot      = new(nfig,graphic)
	file_prec = DIR_DADOS+fontes(i)+".txt"
	ncol      = numAsciiCol(file_prec)
	nlin      = numAsciiRow(file_prec)
	
	f := asciiread(file_prec,(/nlin,ncol/),"float")

	reta := new((/2,nlin/),float)

	j = 1
	m = 0

	do k = 0,ncol-1
	
;		print(" k: " + k + " j: " + j)
		
		print("Fonte: " + fontes(i) + " Estacao: " + estacao(m))

		x  := f(:,j)
		y  := f(:,k)
		rc  = regline(x,y)

		reta(0,:) = y
		reta(1,:) = rc*(x-rc@xave) + rc@yave

		res                      = True
		res@gsnDraw              = False
		res@gsnFrame             = False
		res@xyMarkerSizeF        = 0.009
		res@xyDashPatterns       = (/0,0/)
		res@xyLineThicknesses    = (/2,2/)
		res@xyMarkLineModes      = (/"Markers","lines"/)
		;res@trXMinF              = 2.5
		;res@trXMaxF              = 6.0
		;res@trYMinF              = 3.5
		;res@trYMaxF              = 8.0
		res@tiYAxisString        = "Amazon precipitation (mm/day)"
		res@tiXAxisString        = "Northeast precipitation (mm/day)"
		;res@tiMainString         = titulo(k)
		res@xyMarkerColors       = (/"black"/)
		res@xyMarkers            = (/16,0/)
		res@tmXBMinorOn          = False
		res@tmYLMinorOn          = False
		;res@tmYLMode             = "Manual"
		;res@tmYLTickStartF       = res@trYMinF
		;res@tmYLTickSpacingF     =  0.5
		;res@tmYLTickEndF         = res@trYMaxF
		;res@tmXBMode             = "Manual"
		;res@tmXBTickStartF       = res@trXMinF
		;res@tmXBTickSpacingF     =  0.5
		;res@tmXBTickEndF         = res@trXMaxF
		;res@tmXBFormat           = "0@;*.2f"
		;res@tmYLFormat           = "0@;*.2f"
		res@tiXAxisFontHeightF   = 0.03
		res@tiYAxisFontHeightF   = 0.03
		res@tmYLLabelFontHeightF = 0.03 ; tamanho do texto do eixo y
		res@tmXBLabelFontHeightF = 0.03 ; tamanho do texto do eixo x
		res@tiMainFontHeightF    = 0.04
		res@xyLineColor          = (/"grey"/)
	
		plot(m) = gsn_csm_xy(wks,x,reta,res)

		m = m + 1
		j = j + 2
		k = k + 1

	end do

	print("")

end do

pres                              = True
pres@gsnPanelFigureStrings        = (/"a)","b)","c)","d)","e)","f)","g)","h)","i)","j)","k)","l)","m)","n)","o)","p)","q)","r)","s)","t)"/)
pres@txString                     = "Amazon x Northeast - Mean annual precipitation"
pres@amJust                       = "TopRight"
pres@gsnPanelFigureStringsPerimOn = False
pres@gsnPanelYWhiteSpacePercent   = 5
pres@gsnPanelXWhiteSpacePercent   = 5

gsn_panel(wks,plot,(/dimsizes(fontes),dimsizes(estacao)/),pres)

