load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"

begin
;
; Read in data.
;
  cdf_file = addfile("formary.nc","r")
  data1 = cdf_file->PlotData

;
; Open PNG file.
;
  wks = gsn_open_wks("png", "formary")
;  gsn_define_colormap(wks, )

  res = True
  res@cnLevelSpacingF = 1
  res@cnMaxLevelValF = 150
  res@cnMinLevelValF = 0
  res@tiMainString = "TOLNET Vertical  2015-06-12"
  res@tiYAxisString = "Altitude AGL (km)"
  res@tiXAxisString = "Hours (UTC)"
  res@cnInfoLabelPerimOn = False
  res@cnInfoLabelOn = False
  res@gsnSpreadColorEnd = 200
  res@gsnSpreadColorStart = 2
  res@gsnSpreadColors = True
  res@cnLevelSelectionMode = "ManualLevels"
  res@tmXBLabelFontHeightF = 0.015
  res@tmXBLabels = (/"00:00", "02:00", "04:00", "06:00", "08:00", "10:00", "12:00", "14:00", "16:00", "18:00", "20:00", "22:00"/)
  res@tmXBValues = (/0, 120, 240, 360, 480, 600, 720, 840, 960, 1080, 1200, 1320/)
  res@tmXBMode = "Explicit"
;  res@gsnFrame = False
;  res@gsnDraw = False
  res@vpYF = 0.8
  res@vpXF = 0.15
  res@vpHeightF = 0.45
  res@vpWidthF = 0.68
  res@lbLabelPosition = "Right"
  res@lbOrientation = "Vertical"
  res@lbBoxLinesOn = False
  res@lbLabelStride = 30
  res@lbLabelFontHeightF = 0.015
  res@pmLabelBarHeightF = 0.5
  res@pmLabelBarWidthF = 0.1
  res@tmYLMinorLengthF = 0.002
  res@tmYRMinorLengthF = 0.002
  res@tmYLMajorLengthF = 0.005
  res@tmYRMajorLengthF = 0.005
  res@tmXTMinorLengthF = 0.002
  res@tmXBMinorLengthF = 0.002
  res@tmXTMajorLengthF = 0.005
  res@tmXBMajorLengthF = 0.005
  res@tmXBMinorOn = True
  res@trYMinF = 0
  res@trYMaxF = 2500
  res@sfYArray = cdf_file->sfYArray
  res@cnLineLabelsOn = False
  res@cnLinesOn = False
  res@cnFillOn = True

  plot = gsn_csm_contour(wks, data1, res)
end
