; Demo no color fill when full frame solid color is expected.
; 2015-dec-30 By Dave Allured.  Demo for NCL 6.3.0.

begin
  f = addfile ("data.no-color.nc", "r")
  dat = f->dat
  print ("Data range of full grid = " + min (dat) + ", " + max (dat))

  wks = gsn_open_wks ("x11", "plot.test")
  res                      = True
  res@cnFillOn             = True
  res@cnConstFEnableFill   = True

  res@cnLevelSelectionMode = "ManualLevels"
  res@cnMinLevelValF       = 0
  res@cnMaxLevelValF       = 24
  res@cnLevelSpacingF      = 12   ; smaller generates color fill

  res@mpMinLonF    = 234     ; any boundary outside data limits
  res@mpMaxLonF    = 260     ; generates color fill
  res@mpMinLatF    = 31
  res@mpMaxLatF    = 50

  res@mpCenterLonF = (res@mpMinLonF + res@mpMaxLonF) / 2.0
  res@gsnAddCyclic = False
  res@mpFillOn     = False
  res@mpOutlineBoundarySets = "AllBoundaries"

  plot = gsn_csm_contour_map_ce (wks, dat, res)
end
